/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ItemStackToFluidRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OneInputCachedRecipe<INPUT, OUTPUT, RECIPE extends MekanismRecipe>
extends CachedRecipe<RECIPE> {
    private final IInputHandler<INPUT> inputHandler;
    private final IOutputHandler<OUTPUT> outputHandler;
    private final Predicate<INPUT> inputEmptyCheck;
    private final Supplier<? extends InputIngredient<INPUT>> inputSupplier;
    private final Function<INPUT, OUTPUT> outputGetter;
    private final Predicate<OUTPUT> outputEmptyCheck;
    @Nullable
    private INPUT input;
    @Nullable
    private OUTPUT output;

    protected OneInputCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<INPUT> inputHandler, IOutputHandler<OUTPUT> outputHandler, Supplier<? extends InputIngredient<INPUT>> inputSupplier, Function<INPUT, OUTPUT> outputGetter, Predicate<INPUT> inputEmptyCheck, Predicate<OUTPUT> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        CachedRecipeHelper.oneInputCalculateOperationsThisTick(tracker, this.inputHandler, this.inputSupplier, input -> {
            this.input = input;
        }, this.outputHandler, this.outputGetter, output -> {
            this.output = output;
        }, this.inputEmptyCheck);
    }

    @Override
    public boolean isInputValid() {
        INPUT input = this.inputHandler.getInput();
        return !this.inputEmptyCheck.test(input) && ((Predicate)((Object)this.recipe)).test(input);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.input != null && this.output != null && !this.inputEmptyCheck.test(this.input) && !this.outputEmptyCheck.test(this.output)) {
            this.inputHandler.use(this.input, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }

    public static OneInputCachedRecipe<@NonNull FluidStack, @NonNull ElectrolysisRecipe.ElectrolysisRecipeOutput, ElectrolysisRecipe> separating(ElectrolysisRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull ElectrolysisRecipe.ElectrolysisRecipeOutput> outputHandler) {
        return new OneInputCachedRecipe<FluidStack, ElectrolysisRecipe.ElectrolysisRecipeOutput, ElectrolysisRecipe>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, FluidStack::isEmpty, output -> false);
    }

    public static OneInputCachedRecipe<@NonNull FluidStack, @NonNull FluidStack, FluidToFluidRecipe> fluidToFluid(FluidToFluidRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull FluidStack> inputHandler, IOutputHandler<@NonNull FluidStack> outputHandler) {
        return new OneInputCachedRecipe<FluidStack, FluidStack, FluidToFluidRecipe>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, FluidStack::isEmpty, FluidStack::isEmpty);
    }

    public static OneInputCachedRecipe<@NonNull ItemStack, @NonNull ItemStack, ItemStackToItemStackRecipe> itemToItem(ItemStackToItemStackRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        return new OneInputCachedRecipe<ItemStack, ItemStack, ItemStackToItemStackRecipe>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, ItemStack::m_41619_, ItemStack::m_41619_);
    }

    public static OneInputCachedRecipe<@NonNull ItemStack, @NonNull FluidStack, ItemStackToFluidRecipe> itemToFluid(ItemStackToFluidRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull FluidStack> outputHandler) {
        return new OneInputCachedRecipe<ItemStack, FluidStack, ItemStackToFluidRecipe>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, ItemStack::m_41619_, FluidStack::isEmpty);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> OneInputCachedRecipe<@NonNull ItemStack, @NonNull STACK, RECIPE> itemToChemical(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        return new OneInputCachedRecipe<ItemStack, ChemicalStack, RECIPE>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, ItemStack::m_41619_, ChemicalStack::isEmpty);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>> OneInputCachedRecipe<@NonNull STACK, @NonNull STACK, RECIPE> chemicalToChemical(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull STACK> inputHandler, IOutputHandler<@NonNull STACK> outputHandler) {
        return new OneInputCachedRecipe<ChemicalStack, ChemicalStack, RECIPE>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, ChemicalStack::isEmpty, ChemicalStack::isEmpty);
    }

    public static OneInputCachedRecipe<@NonNull ItemStack, @NonNull SawmillRecipe.ChanceOutput, SawmillRecipe> sawing(SawmillRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler) {
        return new OneInputCachedRecipe<ItemStack, SawmillRecipe.ChanceOutput, SawmillRecipe>(recipe, recheckAllErrors, inputHandler, outputHandler, recipe::getInput, recipe::getOutput, ItemStack::m_41619_, output -> false);
    }
}

